function xdot = extremumswarming_derivative(t, x)

global M a b c w wx ax cx wy ay cy h k beta ar; 
global vx1save vy1save vx2save vy2save vx3save vy3save tsave;

% variable matrix
% A1 A2 A3 T
% x        xt
% y        yt
% eta

%c=sqrt(3)/1.5;%2*sin(pi*t/100);
if t>40
c=sqrt(3)/2;
a =sqrt(3)*c/3;
end


z = zeros(3, M+1);
zdot = zeros(3, M+1);

for i=1:M+1,
  z(:, i) = x(3*(i-1)+1:3*i);
end;

% target and target dynamics
tar=z(1:2,M+1);
% tar_dot(1)=.001*cos(0.02*t)+3;
% tar_dot(2)=.001*sin(0.01*t);
tar_dot(1)=0.25;  
tar_dot(2)=sin(0.25*t); 

for i=1:M
    xp(i)=z(1,i);%xp2=z(1,2);xp3=z(1,3);
    yp(i)=z(2,i);%yp2=z(2,2);yp3=z(2,3);
    eta(i)=z(3,i);%eta(2)=z(3,2);eta(3)=z(3,3);
end

% Computation of potential function  
J(1)=-potential(xp(1),yp(1),xp(2),yp(2),xp(3),yp(3),tar(1),tar(2));
J(2)=-potential(xp(2),yp(2),xp(1),yp(1),xp(3),yp(3),tar(1),tar(2));
J(3)=-potential(xp(3),yp(3),xp(2),yp(2),xp(1),yp(1),tar(1),tar(2));

% One agent
grad_g(:, 1) = 2*(norm(z(1:2, 1) - tar)^2 - a^2)*(z(1:2, 1) - tar) + ...
   2*w*(norm(z(1:2, 1) - z(1:2, 2))^2 - c^2)*(z(1:2, 1) - z(1:2, 2)) + ... 
   2*w*(norm(z(1:2, 1) - z(1:2, 3))^2 - c^2)*(z(1:2, 1) - z(1:2, 3)); 

% Second agent
grad_g(:, 2) = 2*(norm(z(1:2, 2) - tar)^2 - a^2)*(z(1:2, 2) - tar) + ...
   2*w*(norm(z(1:2, 2) - z(1:2, 1))^2 - c^2)*(z(1:2, 2) - z(1:2, 1)) + ... 
   2*w*(norm(z(1:2, 2) - z(1:2, 3))^2 - c^2)*(z(1:2, 2) - z(1:2, 3));

% Third agent
grad_g(:, 3) = 2*(norm(z(1:2, 3) - tar)^2 - a^2)*(z(1:2, 3) - tar) + ...
   2*w*(norm(z(1:2, 3) - z(1:2, 1))^2 - c^2)*(z(1:2, 3) - z(1:2, 1)) + ... 
   2*w*(norm(z(1:2, 3) - z(1:2, 2))^2 - c^2)*(z(1:2, 3) - z(1:2, 2));

epsilon=0.1;

% % Gradient based extremum seeking controller 1
% vx=tar_dot(1)-k*grad_g(1,:);
% vy=tar_dot(2)-k*grad_g(2,:);

% Gradient based extremum seeking controller 2
vx=-k*grad_g(1,:)-beta*sat(grad_g(1,:)/epsilon);
vy=-k*grad_g(2,:)-beta*sat(grad_g(2,:)/epsilon);

% % Gradient based extremum seeking controller 3
% vx=-(k+beta)*sat(grad_g(1,:)/epsilon);
% vy=-(k+beta)*sat(grad_g(2,:)/epsilon);

% % Perturbation based Extremum Seekign Controller
% for i=1:M
%     vx(i)=ax(i)*wx(i)*cos(wx(i)*t)+cx(i)*sin(wx(i)*t)*(J(i)-eta(i));
%     vy(i)=ay(i)*wy(i)*sin(wy(i)*t)-cy(i)*cos(wx(i)*t)*(J(i)-eta(i));
% end

% vehicle dyanmics (pointmass + high pass filter)
for i=1:M
   % velocity, high pass filter
  zdot(1:3,i) = [vx(i)+ar*sin(0.2*t);vy(i)+ar*sin(0.2*t);h(i)*(J(i)-eta(i))];    
end;


% Target dynamics
zdot(1:2, M+1) = tar_dot(:);

% Return a column vector
for i=1:M+1,
  xdot(3*(i-1)+1:3*i) = zdot(:, i);
end;
xdot = xdot'; 

tsave = [tsave;t];
vx1save = [vx1save;vx(1)];
vy1save = [vy1save;vy(1)];
vx2save = [vx2save;vx(2)];
vy2save = [vy2save;vy(2)];
vx3save = [vx3save;vx(3)];
vy3save = [vy3save;vy(3)];
 